
'ODBC V2:
'Enhanced GetColData$ function to handle large field data.
'Closes recordset cursor.
'Add GetStmtHandle function.
'Removed SQLAllocHandle from RunSQL function.
'Removed constraint in create table SQL statement. For test purposes.
'AddSampleRecord adds 200 records. For test purposes.
'Copyright  Dennis McKinney 2002

'                     ODBC with Liberty Basic

'Very basic routines to demonstrate that Access and VB databases
'can be used with Liberty Basic through ODBC.

'                 FOR DEMONSTRATION PURPOSES ONLY

' SYSTEM REQUIREMENTS:
'   MDAC 2.1 or greater
'   Microsoft Jet

    'Keywords for different Access & VB database versions,
    'Support depends on your MDAC version:
    'CREATE_DBV2, prior to Access97
    'CREATE_DBV3, Access97
    'CREATE_DBV4, Access 2000
    'CREATE_DB, creates a version to match the
               'MDAC (Microsoft Data Access Components)
               'installed on the computer.

    '** Globals
    gTmpTable$(0) = ""      'temporary array for table names
    gTable$(0) = ""         'array for table names
    dim gColname$(0)        'for 1 recordset column names
    dim gRowset$(1,1)       'for 1 recordset row values
    dim gColRow(2)          'for 1 recordset row & col count
    struct gHandle, h as long   'for ODBC handles
    struct NativeErrorPtr, errcode as long  'for error handler
    struct TextLengthPtr, length as short
    struct ColumnCountPtr, count as long    'for GetColumns
    struct NumAttPtr, value as short
    '** end Globals


    menu #main, "&File", "E&xit", [Quit]
    menu #main, "&Database", "&New Database", [CreateDatabase], _
                "&Open Database", [OpenDatabase], "&Close", [CloseDatabase]
    menu #main, "&Table", "&Create 1 Test Table", [CreateTable], _
                "&Delete Test Table", [DeleteTable]
    menu #main, "&Records", "&Add Sample Record", [AddSampleRecord], _
                "R&ead Records", [ReadRecords], _
                "&Delete John Smith Record", [DeleteJohnSmith]
    txt$ = "Steps:"+chr$(10)+"1: Create a database (one time)"+chr$(10)
    txt$ = txt$+"2: Open that database"+chr$(10)
    txt$ = txt$+"3: Create a table"+chr$(10)
    txt$ = txt$+"4: Add a record"+chr$(10)
    txt$ = txt$+"5: Experiment"
    statictext #main, txt$,10,50,200,200

    open "ODBC Test 1" for window as #main
    #main, "trapclose [Quit]"

    Open "odbc32.dll" for dll as #odbc

    DbVerKeyword$ = "CREATE_DB"
    Driver$ = "Microsoft Access Driver (*.MDB)" + chr$(0)

    [loop]
    wait

[Quit]
    'every database opened must be closed
    If hDb1 > 0 then
        ret = CloseDatabase(hDb1)
    End if

    'every workspace opened must be closed
    hWksp1 = CloseWorkspace(hWksp1)

    Close #odbc: close #main

    end

[CreateDatabase]
    filedialog "Create New Database"+space$(200)+"save", "*.mdb", DbPath$
    Attributes$ = DbVerKeyword$+"="+chr$(34)+DbPath$+chr$(34)+chr$(0)+chr$(0)
    If right$(DbPath$,4) <> lower$(".mdb") then
        If DbPath$ = "" then
            'nothing
        Else
            Notice "Invalid Database Type"+chr$(13)+"File extension must be *.mdb"
        End if
    Else
        ret = CreateDatabase(Driver$,Attributes$)
    End if
goto [loop]

[OpenDatabase]
    If hDb1 = 0 then
        filedialog "Open Database", "*.mdb", DbPath$
        If right$(DbPath$,4) <> lower$(".mdb") then
            If DbPath$ = "" then
                'nothing
            Else
                Notice "Invalid Database Type"+chr$(13)+"File extension must be *.mdb"
            End if
        Else
            DSNname$ = "Liberty Basic Generic DSN"
            ret = CreateSystemDSN(Driver$,DSNname$,DbPath$,Uid$,Pwd$)
            hWksp1 = OpenWorkspace() 'or Environment
            hDb1 = OpenDatabase(hWksp1,DSNname$,Uid$,Pwd$)
        End if
    Else
        Notice "Database already open."
    End if
goto [loop]

[CloseDatabase]
    hDb1 = CloseDatabase(hDb1)
goto [loop]

[CreateTable]
    If hDb1 > 0 then
        SQL$ = "CREATE TABLE TestTable"
        SQL$ = SQL$ + " (LastName text(30), FirstName text(25),"
        SQL$ = SQL$ + " SSN text(11), Notes text(255));"
        hStmt = GetStmtHandle(hDb1)
        ret = RunSQL(hStmt, SQL$)
        Call FreeStatement hStmt
    End if
goto [loop]

[AddSampleRecord]
 
    If hDb1 > 0 then
        SQL$ = "INSERT INTO TestTable (LastName, FirstName, SSN, Notes)"
        SQL$ = SQL$ + " VALUES('Smith', 'John', '123-45-6789', 'Good Programmer');"
        Cursor hourglass
        hStmt = GetStmtHandle(hDb1)
    for i = 1 to 200
        ret = RunSQL(hStmt, SQL$)
        If ret = 0 then exit for
    next i
        Call FreeStatement hStmt
        Cursor Normal
    End if
goto [loop]

[ReadRecords]
    If hDb1 > 0 then
        Cursor hourglass
        SQL$ = "SELECT FirstName, LastName, SSN, Notes"
        SQL$ = SQL$ + " FROM TestTable;"

        ret = OpenRecordset(hDb1,SQL$)

        cls
        If ret <> 0 then
            for i = 1 to gColRow(1)
                print gColname$(i)+space$(16-len(gColname$(i)));
            next i
        End If
        print
        print
        for i = 1 to gColRow(2)
            print str$(i);
            for j = 1 to gColRow(1)
                print gRowset$(i,j)+space$(16-len(gRowset$(i,j)));
            next j
            print " "
        next i
        Cursor normal
    End if
goto [loop]

[DeleteTable]
    If hDb1 > 0 then
        SQL$ = "DROP TABLE TestTable"
        hStmt = GetStmtHandle(hDb1)
        ret = RunSQL(hStmt, SQL$)
        Call FreeStatement hStmt
    End if
goto [loop]

[DeleteJohnSmith]
    If hDb1 > 0 then
        SQL$ = "DELETE * FROM TestTable WHERE FirstName = 'John'"
        SQL$ = SQL$ + " AND LastName = 'Smith';"
        hStmt = GetStmtHandle(hDb1)
        ret = RunSQL(hStmt, SQL$)
        Call FreeStatement hStmt
    End if
goto [loop]


'*********************** SUBS & FUNCTIONS ******************************

Function OpenRecordset(hDb,SQL$)
 
    SQL.NO.DATA = 100
    hStmt = GetStmtHandle(hDb)
    ret = RunSQL(hStmt, SQL$)
    if ret <> 0 then cols = GetColumnCount(hStmt)
    if cols > 0 then 'a recordset was created
        Redim gColname$(cols)
        For i = 1 to cols
           gColname$(i) = GetColNames$(hStmt,i)
        Next i

        Redim gRowset$(10000,cols)
        'move to the first row of the result set
        calldll #odbc,"SQLFetch",hStmt as long,ret as short

        i = 1
        While ret <> SQL.NO.DATA
            For j = 1 to cols
                gRowset$(i,j) = GetColData$(hDb,hStmt,j)
            Next j
            i = i + 1
            calldll #odbc,"SQLFetch",hStmt as long,ret as short
            If i > 1999 then Exit While
            'if i > 999 the array will need redim preserve routine
        Wend

        'store col & row count
        gColRow(1) = cols
        gColRow(2) = i-1

        OpenRecordset = 1 'success
    else
        OpenRecordset = 0 'fail
    end if

    calldll #odbc,"SQLCloseCursor",hStmt as long,ret as short
    Call FreeStatement hStmt
End Function

Function GetColData$(hDb,hStmt,ColNum)
    SQLState$ = space$(5) + chr$(0)
    MessageText$ = space$(256) + chr$(0)
    SQL.Char = 1
    SQL.SUCCESS = 0
    SQL.SUCCESS.WITH.INFO = 1
    SQL.NO.DATA = 100
    SQL.ERROR = -1
    'To test the handling of truncated data use:
    'Buffer$ = Space$(10) + chr$(0)
    Buffer$ = Space$(512) + chr$(0)
    Buflen = len(Buffer$)

    While ret <> SQL.NO.DATA
        calldll #odbc,"SQLGetData",hStmt as long,ColNum as short, _
            SQL.Char as short,Buffer$ as ptr, Buflen as short, _
            TextLengthPtr as ptr,ret as short
        Select case ret
            case SQL.SUCCESS
                GetColData$ = GetColData$ + _
                left$(Buffer$, TextLengthPtr.length.struct)
            case SQL.ERROR
                GetColData$ = ""
                Exit While
            case SQL.SUCCESS.WITH.INFO
                calldll #odbc,"SQLGetDiagRec",3 as short,hStmt as long, _
                1 as short,SQLState$ as ptr,NativeErrorPtr as ptr, _
                MessageText$ as ptr,256 as short,TextLengthPtr as ptr, _
                ret as short
                If left$(SQLState$,5) = "01004" then
                    GetColData$ = GetColData$ + _
                    left$(Buffer$,instr(Buffer$,chr$(0))-1)
                End if
        End select
    Wend
End Function

Function GetColNames$(hStmt,ColNum)
    SQL.COLUMN.LABEL  = 18
    Buffer$ = Space$(256) + chr$(0)
    calldll #odbc,"SQLColAttribute",hStmt as long,ColNum as short, _
        SQL.COLUMN.LABEL as short,Buffer$ as ptr,255 as short, _
        TextLengthPtr as ptr,NumAttPtr as ptr,ret as short

    GetColNames$ = left$(Buffer$, TextLengthPtr.length.struct)
End Function

Function GetColumnCount(hStmt)
 'In: statement handle.
 'Out: number of columns in result set, if any.
 '0 if error or no result set was created.
    SQL.SUCCESS = 0
    SQL.STILL.EXECUTING = 2
    ColumnCountPtr.count.struct = 0

    ret = SQL.STILL.EXECUTING
    While ret = SQL.STILL.EXECUTING
        calldll #odbc,"SQLNumResultCols",hStmt as long, _
            ColumnCountPtr as ptr,ret as short
        Select Case ret
            case SQL.STILL.EXECUTING
            case SQL.SUCCESS
                GetColumnCount = ColumnCountPtr.count.struct
            case Else
                Call ErrMsg 3,hStmt
                GetColumnCount = 0
        End Select
    Wend
End Function

Function CreateSystemDSN(Driver$,DSNname$,DbPath$,Uid$,Pwd$)
    Attributes$="DSN="+DSNname$+chr$(0)+"Uid="+Uid$+chr$(0)+"Pwd="+Pwd$+chr$(0)
    Attributes$=Attributes$+"DBQ="+DbPath$+chr$(0)+chr$(0)

    open "odbccp32.dll" for dll as #odbccp32
    calldll #odbccp32,"SQLConfigDataSource",0 as long,4 as short, _
        Driver$ as ptr,Attributes$ as ptr,ret as boolean
    close #odbccp32

    If ret = 0 Then
        Notice "Create DSN Error"+chr$(13)+"Failed to create DSN"
    End If
    CreateSystemDSN = ret
End Function

Function CreateDatabase(Driver$,Attributes$)
    open "odbccp32.dll" for dll as #odbccp32
    calldll #odbccp32,"SQLConfigDataSource",0 as long,1 as short, _
        Driver$ as ptr,Attributes$ as ptr,ret as boolean
    close #odbccp32

    If ret = 0 Then
        Notice "Create Database Error"+chr$(13)+"Failed to create database"
    End If
    CreateDatabase = ret
End Function

Function GetTables(InputHandle)
 'Purpose: fill gTable$ array with table names
 'In: database connection handle
 'Out: number of table names added to gTable$ array
    Redim gTmpTable$(10000)
    struct LenRead, val as long
    struct OutputHandlePtr, handle as long
    SQL.NO.DATA = 100
    SQL.HANDLE.STMT = 3
    TableName$ = Space$(256) + chr$(0)
    TableType$ = "'TABLE'" + chr$(0)
    lenTableType = Len(TableType$)

    calldll #odbc, "SQLAllocHandle",SQL.HANDLE.STMT as short, _
        InputHandle as long,OutputHandlePtr as ptr,ret as short
    If ret <> 0 then
        GetTables = 0
        goto [exitGetTables]
    End If
    hStmt = OutputHandlePtr.handle.struct

    calldll #odbc, "SQLTables",hStmt as long,0 as short,-3 as short, _
        0 as short,-3 as short,0 as short,-3 as short,TableType$ as ptr, _
        lenTableType as short,ret as short

    If ret <> 0 then
        Call ErrMsg 3,hStmt
        GetTables = 0
        goto [exitGetTables]
    End If

    calldll #odbc,"SQLFetch",hStmt as long,ret as short
    If ret <> 0 then
        GetTables = 0
        goto [exitGetTables]
    End If

    count = 0
    While intRc <> SQL.NO.DATA
        calldll #odbc,"SQLGetData",hStmt as long,3 as short,1 as short, _
        TableName$ as ptr,255 as short,LenRead as ptr,intRc as short

        TableName$ = left$(TableName$,LenRead.val.struct)

        gTmpTable$(count) = TableName$
        count = count + 1

        TableName$ = Space$(256) + chr$(0)
        calldll #odbc,"SQLFetch",hStmt as long,intRc as short
    Wend

    Redim gTable$(count)
    For i = 0 to count-1
        gTable$(i) = gTmpTable$(i)
    next i
    Redim gTmpTable$(0)

    GetTables = count

 [exitGetTables]
    Call FreeStatement hStmt
End Function

Function OpenWorkspace()
 'Out: Workspace (environment) handle.
    gHandle.h.struct = 0
    calldll #odbc,"SQLAllocHandle",1 as short,0 as long,gHandle as ptr, _
        ret as short
    hEnv = gHandle.h.struct

    ver3 = 3 'use ODBC 3
    calldll #odbc,"SQLSetEnvAttr",hEnv as long,200 as long,ver3 as long, _
        0 as long,ret as short

    OpenWorkspace = hEnv
End Function

Function CloseWorkspace(hWorkspace)
    calldll #odbc,"SQLFreeHandle",1 as short,hWorkspace as long,ret as short
    CloseWorkspace = ret
End Function

Function OpenDatabase(WorkSpace,DSNname$,Uid$,Pwd$)
 'In: Workspace/environment handle, datasource name,
     'optional user ID, optional password.
 'Out: database connection handle, 0 if failed.
    lenDSN = len(DSNname$)
    lenUid = len(Uid$)
    lenPwd = len(Pwd$)

    gHandle.h.struct = 0
    calldll #odbc,"SQLAllocHandle",2 as short,WorkSpace as long, _
    gHandle as ptr,ret as short

    hCon = gHandle.h.struct

    calldll #odbc,"SQLConnect",hCon as long,DSNname$ as ptr, _
        lenDSN as short,Uid$ as ptr,lenUid as short,Pwd$ as ptr, _
        lenPwd as short,ret as short

    IF ret <> 0 then
        Call ErrMsg 2,hCon
        hCon = CloseDatabase(hCon)
    End IF

    OpenDatabase = hCon
End Function

Function CloseDatabase(hDb)
 'In: database connection handle.
 'Out: 0 if successful, >0 if failed.
    calldll #odbc,"SQLDisconnect",hDb as long,ret as short
    calldll #odbc,"SQLFreeHandle",2 as short,hDb as long,ret as short

    IF ret <> 0 then Call ErrMsg 2,hDb

    CloseDatabase = ret
End Function

Function GetStmtHandle(hDBC)
    gHandle.h.struct = 0

    calldll #odbc,"SQLAllocHandle",3 as short,hDBC as long, _
        gHandle as ptr, ret as short
    hStmt = gHandle.h.struct

    GetStmtHandle = hStmt
End Function

Function RunSQL(hStmt,strSQL$)
 'In: database connection handle, SQL statement to execute.
 'Out: 0 if failed, statement handle if successful.
 'Don't forget to free the statement handle.

    SQL.STILL.EXECUTING = 2

    lenStmt = len(strSQL$)

    ret = SQL.STILL.EXECUTING
    While ret = SQL.STILL.EXECUTING
        calldll #odbc, "SQLExecDirect",hStmt as long,strSQL$ as ptr,_
            lenStmt as short,ret as short
    Wend

    If ret <> 0 then
        Call ErrMsg 3,hStmt
        RunSQL = 0
        goto [exitRunSQL]
    End If

    RunSQL = hStmt
 [exitRunSQL]
End Function

Sub FreeStatement hStmt
    calldll #odbc,"SQLFreeHandle",3 as short,hStmt as long,ret as short
End Sub

Sub ErrMsg hType,Hndl
    SQLState$ = space$(5) + chr$(0)
    MessageText$ = space$(256) + chr$(0)

    calldll #odbc,"SQLGetDiagRec",hType as short,Hndl as long, _
    1 as short,SQLState$ as ptr,NativeErrorPtr as ptr, _
    MessageText$ as ptr,256 as short,TextLengthPtr as ptr,ret as short
    i = i + 1

    msg$ = "SQLState Code: "+left$(SQLState$,5)+chr$(10)
    msg$=msg$+"Native Error: "+str$(NativeErrorPtr.errcode.struct)+chr$(10)
    msg$=msg$+left$(MessageText$,TextLengthPtr.length.struct)

    If msg$ <> "" Then
        Notice "LB ODBC Error"+chr$(13)+msg$
    Else
        Notice "LB ODBC Error"+chr$(13)+"An unKnown error occured. Check your code."
    End if
End Sub


